#include <cassert>
#include <cstdio>
#include <ctime>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <algorithm>
#include <iostream>
#include <set>
#include <map>
#include <vector>
#include <queue>
#include <deque>
using namespace std;
#define pb push_back
#define mp make_pair
#define fs first
#define sc second
#define sz(a) ((int) (a).size())
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#define int64 long long
#define ldb long double
const double pi = acos(-1.0);
const int N = (int) 55555;
const int INF = (int) 1e6;
const double eps = 1e-10;
const int max_it = 40;
int x[N], n, r[N];
pair<double, double> segs[2 * N];

double sqr(double x) {
	return x * x;
}

bool cross(const pair<double, double>& p1, const pair<double, double>& p2) {
	return max(p1.fs, p2.fs) < min(p1.sc, p2.sc) + eps;
}

bool check(double a) {
	int len = 0;
	for (int i = 0; i < n; ++i)
		if (r[i] >= a / 2 + eps) {
			double sq = sqrt(sqr(r[i]) - sqr(a / 2));
			segs[len++] = mp(x[i] - sq, x[i] + sq);
			while ((len >= 2) && cross(segs[len - 2], segs[len - 1])) {
				double nl = min(segs[len - 2].fs, segs[len - 1].fs);
				double nr = max(segs[len - 2].sc, segs[len - 1].sc);
				len -= 2;
				segs[len++] = mp(nl, nr);
			}
		}
	for (int i = 0; i < len; ++i)
		if (segs[i].sc - segs[i].fs > a - eps) return true;
	return false;
}

int main() {
	/*assert(freopen("input.txt", "w", stdout));
	for (int t = 0; t < 30; ++t) {
	printf("%d\n", 50000);
	for (int i = 0; i < 50000; ++i)
		printf("%d %d\n", rand(), 100000);
	}
		printf("0\n");
	return 0;*/
	//double start = clock();
	assert(freopen("input.txt", "r", stdin));
	assert(freopen("output.txt", "w", stdout));
	while ((scanf("%d", &n) == 1) && (n > 0)) {
		for (int i = 0; i < n; ++i)
			scanf("%d%d", &x[i], &r[i]);
		double l = 0, r = INF;
		for (int it = 0; it < max_it; ++it) {
			double q = (l + r) / 2;
			(check(q) ? l : r) = q;
		}
		printf("%.10lf\n", l);
	}
	//printf("%.2lf\n", (clock() - start) / CLOCKS_PER_SEC);
	return 0;
}